package de.blauerfalke.tetris.view


import scala.swing.Component
import java.awt.Graphics2D
import java.awt.Color
import java.awt.event.{ActionListener, ActionEvent}
import de.blauerfalke.tetris.control.Control
import java.awt.event.KeyListener
import java.awt.event.KeyEvent


object Field {
	val fieldWidth = 11
	val fieldHeight = 18
}
class Field extends Component {
	val control = new Control(this)
	var stone = Stone(0)
	var blocks:List[Block] = List()
	
	peer.setFocusable(true);
	//Keyboard Input
	peer.addKeyListener(new KeyListener() {
	   def keyTyped(e: KeyEvent) = {  }
	   def keyPressed(e: KeyEvent) = {
	  	   if(e.getKeyCode==KeyEvent.VK_LEFT )  control.Mover ! "left"
	  	   if(e.getKeyCode==KeyEvent.VK_RIGHT ) control.Mover ! "right"
	  	   if(e.getKeyCode==KeyEvent.VK_DOWN )  control.Mover ! "down"
	  	   if(e.getKeyCode==KeyEvent.VK_SPACE ) control.Mover ! "turnl" 
	  	   if(e.getKeyCode==KeyEvent.VK_ENTER ) control.Mover ! "turnr"
	   }
	   def keyReleased(e: KeyEvent) =  {}
	})
	
	
	//Repaint all 50 msec
	new javax.swing.Timer(50 , new ActionListener { def actionPerformed(ae:ActionEvent) { repaint } }).start
	//var t:Actor = actor { loop { reactWithin(50) { case "repaint" => {repaint; t ! "repaint" } } }  }.start; t ! "repaint"
	
	override def paintComponent(g: Graphics2D) {
		g.setColor(Color.black)
		g.fillRect(0,0, Field.fieldWidth*Block.blockSize ,Field.fieldHeight*Block.blockSize)
		
		for(b <- blocks)
			b.paint(g)
		
		stone.paint(g)
	}
}