package de.blauerfalke.tetris

import java.awt.Graphics
import java.awt.Color
import java.util.Random

object Stone {
	
	def apply(typ:Int) = {
		typ match {
			case -1 => new Stone(Array())
			case 1 => new Stone(Array( Block(0,0,Color.blue)  ,Block(0,1,Color.blue)  ,Block(0,2,Color.blue)  ,Block(1,2, Color.blue) ))
			case 2 => new Stone(Array( Block(1,0,Color.green) ,Block(1,1,Color.green) ,Block(1,2,Color.green) ,Block(0,2,Color.green) ))
			case 3 => new Stone(Array( Block(0,0,Color.red)   ,Block(0,1,Color.red)   ,Block(1,1,Color.red)   ,Block(1,2,Color.red)   ))
			case 4 => new Stone(Array( Block(1,0,Color.orange),Block(1,1,Color.orange),Block(0,1,Color.orange),Block(0,2,Color.orange)))
			case 5 => new Stone(Array( Block(1,0,Color.pink)  ,Block(1,1,Color.pink)  ,Block(0,1,Color.pink)  ,Block(1,2,Color.pink)  ))
			case 6 => new Stone(Array( Block(0,0,Color.yellow),Block(1,0,Color.yellow),Block(0,1,Color.yellow),Block(1,1,Color.yellow)))
			case 7 => new Stone(Array( Block(0,0,Color.cyan)  ,Block(0,1,Color.cyan)  ,Block(0,2,Color.cyan)  ,Block(0,3,Color.cyan)  ))
		}
	}
}

class Stone(var blocks:Array[Block]) {
	var p = (0,0)		//position
	
	def down() { 
		p = (p._1, p._2+1) 
	}
	
	def paint(g:Graphics) {
		for(b <- blocks)
			b.paint(g)	
	}
}